/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.audio;

import com.tino1b2be.audio.AudioFile;
import com.tino1b2be.audio.AudioFileException;
import java.io.IOException;

public class TempAudio
implements AudioFile {
    private double[] samples;
    private double[][] samples2;
    private int Fs;
    private int samplesRead = 0;
    private boolean mono = false;

    public TempAudio(double[] samples, int fs) throws AudioFileException {
        if (fs < 8000) {
            throw new AudioFileException("Sampling Frequency must be greater than 8kHz.");
        }
        this.samples = samples;
        this.Fs = fs;
        this.mono = true;
    }

    public TempAudio(double[][] samples, int fs) throws AudioFileException {
        if (fs < 8000) {
            throw new AudioFileException("Sampling Frequency must be greater than 8kHz.");
        }
        if (samples[0].length != samples[1].length) {
            throw new AudioFileException("Both channels must contain the same number of samples.");
        }
        this.samples2 = samples;
        this.Fs = fs;
    }

    @Override
    public int read(double[] buffer) throws AudioFileException {
        int read = 0;
        for (int i = 0; i < buffer.length; ++i) {
            if (this.samplesRead == this.samples.length) {
                throw new AudioFileException("No more samples to read.");
            }
            if (i + this.samplesRead >= 6390 || this.samplesRead >= 6390) {
                System.out.println("asdf");
            }
            buffer[i] = this.samples[this.samplesRead];
            ++read;
            ++this.samplesRead;
        }
        return read;
    }

    @Override
    public int read(double[][] buffer) throws AudioFileException {
        int read = 0;
        for (int i = 0; i < buffer.length; ++i) {
            if (this.samplesRead == this.samples.length) {
                throw new AudioFileException("No more samples to read.");
            }
            buffer[0][i] = this.samples2[0][i + this.samplesRead];
            buffer[1][i] = this.samples2[1][i + this.samplesRead];
            ++read;
            ++this.samplesRead;
        }
        return read;
    }

    @Override
    public String getFileProperties() {
        if (this.mono) {
            return "Temporary Audio File generated for the samples given.\nSampling Frequency = " + this.Fs + "\nNumber of samples = " + this.samples.length;
        }
        return "Temporary Audio File generated for the samples given.\nSampling Frequency = " + this.Fs + "\nNumber of samples = " + this.samples2[0].length;
    }

    @Override
    public int getSampleRate() {
        return this.Fs;
    }

    @Override
    public void close() throws IOException {
        this.samples = null;
        this.samples2 = null;
    }

    @Override
    public int getNumChannels() {
        if (this.mono) {
            return 1;
        }
        return 2;
    }
}

